% DESCRIPTION:
%       script to expand the grid matrices used in kspaceFirstOrder1D,
%       kspaceFirstOrder2D, and kspaceFirstOrder3D
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 20th August 2010
%       last update - 7th February 2011
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)
% Copyright (C) 2009, 2010, 2011 Bradley Treeby and Ben Cox

% This file is part of k-Wave. k-Wave is free software: you can
% redistribute it and/or modify it under the terms of the GNU Lesser
% General Public License as published by the Free Software Foundation,
% either version 3 of the License, or (at your option) any later version.
% 
% k-Wave is distributed in the hope that it will be useful, but WITHOUT ANY
% WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
% FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
% more details. 
% 
% You should have received a copy of the GNU Lesser General Public License
% along with k-Wave. If not, see <http://www.gnu.org/licenses/>.

% enlarge the sensor mask
if use_sensor
    sensor.mask = expandMatrix(sensor.mask, expand_size, 0);
end

% enlarge the grid of sound speed by extending the edge values into the
% expanded grid 
if numel(c) > 1
    c = expandMatrix(c, expand_size);
end

% enlarge the grid of density by extending the edge values into the
% expanded grid    
if numel(rho0) > 1
    rho0 = expandMatrix(rho0, expand_size);
end

% enlarge the display mask if given
if ~(strcmp(display_mask, 'default') || strcmp(display_mask, 'off'))
    display_mask = expandMatrix(display_mask, expand_size, 0);
end

% enlarge the initial pressure if given
if isfield(source, 'p0')
    source.p0 = expandMatrix(source.p0, expand_size, 0);
end      

% enlarge the absorption filter mask if given
if isfield(medium, 'alpha_filter');
    medium.alpha_filter = expandMatrix(medium.alpha_filter, expand_size, 0);
end 

% enlarge the pressure source mask if given
if p_source   
    % update the source indexing variable
    if ~isfield(source, 'p_mask') && strcmp(class(sensor), 'kWaveTransducer')
        % create an indexing variable corresponding to the source elements
        ps_index = find(sensor.mask ~= 0); 
    else
        % enlarge the pressure source mask
        source.p_mask = expandMatrix(source.p_mask, expand_size, 0);
        
        % create an indexing variable corresponding to the source elements
        ps_index = find(source.p_mask ~= 0);
    end    
    
end

% enlarge the velocity source mask if given
if u_source   
    % update the source indexing variable
    if ~isfield(source, 'u_mask') && strcmp(class(sensor), 'kWaveTransducer')
        % create an indexing variable corresponding to the source elements
        us_index = find(sensor.mask ~= 0);
    else
        % enlarge the velocity source mask
        source.u_mask = expandMatrix(source.u_mask, expand_size, 0);
        
        % create an indexing variable corresponding to the source elements
        us_index = find(source.u_mask ~= 0);  
    end
end